#!/bin/bash

set -eu -o pipefail

LAVA_GUNICORN_WORKER_CLASS="${LAVA_GUNICORN_WORKER_CLASS:-eventlet}"
LAVA_GUNICORN_WORKER_NUM="${LAVA_GUNICORN_WORKER_NUM:-4}"
LAVA_GUNICORN_WORKER_CONNECTIONS="${LAVA_GUNICORN_WORKER_CONNECTIONS:-23}"  # 23*4 == 92
LAVA_GUNICORN_BIND_ADDR="${LAVA_GUNICORN_BIND_ADDR:-0.0.0.0}"
LAVA_GUNICORN_BIND_PORT="${LAVA_GUNICORN_BIND_PORT:-8000}"


exec /usr/bin/gunicorn3 lava_server.wsgi \
    -u lavaserver -g lavaserver \
    --preload \
    --worker-class "$LAVA_GUNICORN_WORKER_CLASS" \
    --workers "$LAVA_GUNICORN_WORKER_NUM" \
    --worker-connections "$LAVA_GUNICORN_WORKER_CONNECTIONS" \
    --bind "${LAVA_GUNICORN_BIND_ADDR}:${LAVA_GUNICORN_BIND_PORT}"
