#!/bin/bash

set -eu -o pipefail

DATABASE="$(python3 -c 'import os; from urllib.parse import urlparse; url = urlparse(os.environ["DATABASE_URL"]); print("{}:{}".format(url.hostname, url.port), end="")')"

/usr/bin/wait-for-it -t 30 "$DATABASE"

lava-server manage migrate --noinput --fake-initial
lava-server manage drop_materialized_views
lava-server manage refresh_queries --all
